<?php
/******************************************************************************
Etano
===============================================================================
File:                       message_send.php
$Revision: 679 $
Software by:                DateMill (http://www.datemill.com)
Copyright by:               DateMill (http://www.datemill.com)
Support at:                 http://www.datemill.com/forum
*******************************************************************************
* See the "docs/licenses/etano.txt" file for license.                         *
******************************************************************************/

require 'includes/common.inc.php';
require _BASEPATH_.'/includes/user_functions.inc.php';
require _BASEPATH_.'/includes/tables/user_inbox.inc.php';
require _BASEPATH_.'/skins_site/'.get_my_skin().'/lang/mailbox.inc.php';

$tpl=new phemplate(_BASEPATH_.'/skins_site/'.get_my_skin().'/','remove_nonjs');

// Set defaults
$output=$user_inbox_default['defaults'];

// Error from input??
if (isset($_SESSION['topass']['input'])) {
	$output=$_SESSION['topass']['input'];
	$output['_user_other']=get_user_by_userid($output['fk_user_id']);
	unset($_SESSION['topass']['input']);
	$temp='message_write';
	if (isset($_SESSION[_LICENSE_KEY_]['user'][$output['refnum']])) {
		$temp=$_SESSION[_LICENSE_KEY_]['user'][$output['refnum']];
	}
	check_login_member($temp);

// Sending new message??
} elseif (!empty($_GET['to_id'])) {
	$output['fk_user_id']=(int)$_GET['to_id'];
	$output['_user_other']=get_user_by_userid($output['fk_user_id']);
	check_login_member('message_write');
	
// Replying to message
} elseif (!empty($_GET['mail_id'])) {
	
	$output['refnum']=mt_rand(10000,99999);
	$_SESSION[_LICENSE_KEY_]['user'][$output['refnum']]='message_reply';
	check_login_member('message_reply');
	$mail_id=(int)$_GET['mail_id'];
	
	// Get message
	$query="SELECT `mail_id`,`fk_user_id_other` as `fk_user_id`,`subject`,`message_body`,`_user_other`,`message_type`,`date_sent` as `date_sent_raw` FROM `{$dbtable_prefix}user_inbox` WHERE `mail_id`=$mail_id AND `fk_user_id`='".$_SESSION[_LICENSE_KEY_]['user']['user_id']."'";
	if (!($res=@mysql_query($query))) {trigger_error(mysql_error(),E_USER_ERROR);}
	if (mysql_num_rows($res)) {
		$output=array_merge($output,mysql_fetch_assoc($res));
		$output['subject']=(substr($output['subject'],0,3)=='Re:') ? $output['subject'] : 'Re: '.$output['subject'];
		$output['message_body']='';
	}
	
	// Get template if set
	if (isset($_GET['gettpl'])) {
		$tpl_id=(int)$_GET['gettpl'];
		$query="SELECT `subject`,`message_body` FROM `{$dbtable_prefix}user_mtpls` WHERE `mtpl_id`=$tpl_id AND `fk_user_id`='".$_SESSION[_LICENSE_KEY_]['user']['user_id']."'";
		if (!($res=@mysql_query($query))) {trigger_error(mysql_error(),E_USER_ERROR);}
		if (mysql_num_rows($res)) {
			$output=array_merge($output,mysql_fetch_assoc($res));
		}
	}
	
	// Is flirt??
	if ($output['message_type']==MESS_FLIRT) {
		$output['flirt_reply']=true;
	}
	
} else {
	trigger_error($GLOBALS['_lang'][120],E_USER_ERROR);
}

$output['lang_263']=sanitize_and_format($GLOBALS['_lang'][263],TYPE_STRING,$__field2format[TEXT_DB2DISPLAY]);
$output['lang_264']=sanitize_and_format($GLOBALS['_lang'][264],TYPE_STRING,$__field2format[TEXT_DB2DISPLAY]);
$output['lang_196']=sanitize_and_format($GLOBALS['_lang'][196],TYPE_STRING,$__field2format[TEXT_DB2DISPLAY]);
$output['lang_197']=sanitize_and_format($GLOBALS['_lang'][197],TYPE_STRING,$__field2format[TEXT_DB2DISPLAY]);

if (!isset($output['return']) && isset($_GET['return'])) {
	$output['return']=sanitize_and_format_gpc($_GET,'return',TYPE_STRING,$__field2format[FIELD_TEXTFIELD] | FORMAT_RUENCODE,'');
}

// is BBCODE enabled??
$output['bbcode_message']=get_site_option('bbcode_message','core');
if (empty($output['bbcode_message'])) {
	unset($output['bbcode_message']);
}


// -----------------------------------------------------------
// Message History Mod
// -----------------------------------------------------------
		
$loop=array();
			
if(isset($output['fk_user_id']) && !empty($output['fk_user_id'])){
	if(isset($mail_id) && !empty($mail_id) && isset($output['date_sent_raw'])){
		$mail_date=$output['date_sent_raw'];
	}else{
		$mail_date=gmdate('YmdHis');
	}

	$tpl->set_var('show_history',TRUE);
	
	$photoRes=array('user_photo' => 'no_photo.gif',	'other_photo' => 'no_photo.gif');
	
	$userPhoto="SELECT a.`_photo` as `user_photo`,b.`_photo` as `other_photo` FROM `{$dbtable_prefix}user_profiles` a, `{$dbtable_prefix}user_profiles` b WHERE a.`fk_user_id` = ".$_SESSION[_LICENSE_KEY_]['user']['user_id']." AND b.`fk_user_id` = ".$output['fk_user_id']."";
	if (!($res=@mysql_query($userPhoto))) {trigger_error(mysql_error(),E_USER_ERROR);}
	if (mysql_num_rows($res)) {
		$photoRes2=mysql_fetch_assoc($res);
		if(!empty($photoRes2['user_photo']) && is_file(_PHOTOPATH_.'/t1/'.$photoRes2['user_photo'])){
			$photoRes['user_photo']=$photoRes2['user_photo'];
		}
		if(!empty($photoRes2['other_photo']) && is_file(_PHOTOPATH_.'/t1/'.$photoRes2['other_photo'])){
			$photoRes['other_photo']=$photoRes2['other_photo'];
		}
	}
	
	$query="
		SELECT `mail_id`,`is_read`,`fk_user_id_other` as `sender`,`_user_other` as `user_other`,`subject`,`message_body`,UNIX_TIMESTAMP(`date_sent`) as `date_sent`,`message_type` FROM {$dbtable_prefix}user_inbox WHERE `fk_user_id`=".$_SESSION[_LICENSE_KEY_]['user']['user_id']." AND `fk_user_id_other`=".$output['fk_user_id']." AND `del` = 0 AND `date_sent` <= '".$mail_date."' 
		UNION ALL 
		SELECT `mail_id`,`is_read`,`fk_user_id` as `sender`,`_user_other` as `user_other`,`subject`,`message_body`,UNIX_TIMESTAMP(`date_sent`) as `date_sent`,`message_type` FROM {$dbtable_prefix}user_outbox WHERE `fk_user_id`=".$_SESSION[_LICENSE_KEY_]['user']['user_id']." AND `fk_user_id_other`=".$output['fk_user_id']." AND `date_sent` <= '".$mail_date."' 
		ORDER BY `date_sent` DESC LIMIT 5";
	if (!($res=@mysql_query($query))) {trigger_error(mysql_error(),E_USER_ERROR);}
	while ($rsrow=mysql_fetch_assoc($res)) {
		$rsrow['date_sent']=strftime($_SESSION[_LICENSE_KEY_]['user']['prefs']['datetime_format'],$rsrow['date_sent']+$_SESSION[_LICENSE_KEY_]['user']['prefs']['time_offset']);
		$rsrow['allow_reply']=true;
		if($rsrow['sender'] == $_SESSION[_LICENSE_KEY_]['user']['user_id']){
			$msg_folder='OUTBOX';
			$rsrow['allow_reply']=false;
			$rsrow['user_other']='You';
			$rsrow['photo']=$photoRes['user_photo'];
			$rsrow['is_sender']=true;
			$rsrow['fid']=FOLDER_OUTBOX;
		} else {
			$msg_folder='INBOX';
			if ($rsrow['message_type']==MESS_SYSTEM && empty($rsrow['user_other'])) {
				$rsrow['user_other']=$GLOBALS['_lang'][135];
			} else {
				$rsrow['allow_reply']=true;
				$rsrow['user_other']=get_user_by_userid($rsrow['sender']);
				$rsrow['is_sender']=false;
			}
			$rsrow['fid']=FOLDER_INBOX;
			$rsrow['photo']=$photoRes['other_photo'];
		}
					
		$rsrow['message_body']=text2smilies(bbcode2html($rsrow['message_body']));
					
		// Mark unread messages as read if unread messages are loaded
		// happens when a user selects a newer message from the same user
		if($rsrow['is_read'] == 0){
			if($msg_folder == 'INBOX'){
				$query2="UPDATE `{$dbtable_prefix}user_inbox` SET `is_read`=1 WHERE `mail_id`=".$rsrow['mail_id']." AND `fk_user_id`='".$_SESSION[_LICENSE_KEY_]['user']['user_id']."'";
				if (!($res2=@mysql_query($query2))) {trigger_error(mysql_error(),E_USER_ERROR);}
			}elseif($msg_folder='OUTBOX'){
				$query2="UPDATE `{$dbtable_prefix}user_outbox` SET `is_read`=1 WHERE `mail_id`=".$rsrow['mail_id']." AND `fk_user_id`='".$_SESSION[_LICENSE_KEY_]['user']['user_id']."'";
				if (!($res2=@mysql_query($query2))) {trigger_error(mysql_error(),E_USER_ERROR);}
			}
		}
		
		if ($rsrow['date_sent']>$page_last_modified_time) {
			$page_last_modified_time=$rsrow['date_sent'];
		}
		
		$loop[]=$rsrow;
	}
}else{
	$tpl->set_var('show_history',FALSE);
}

$tpl->set_loop('loop',$loop);

// -----------------------------------------------------------
// End Message History
// -----------------------------------------------------------

$tpl->set_file('content','message_send.html');
$tpl->set_var('output',$output);
$tpl->process('content','content',TPL_LOOP | TPL_NOLOOP | TPL_OPTLOOP | TPL_OPTIONAL);

$tplvars['page_title']=sprintf($GLOBALS['_lang'][137],$output['_user_other']);
$tplvars['title']=$tplvars['page_title'];
$tplvars['page']='message_send';
$tplvars['css']='message_send.css';
if (is_file('message_send_left.php')) {
	include 'message_send_left.php';
}
include 'frame.php';
